/*
 *  script.js
 *
 *  Copyright: (c) 2018 FileMaker, Inc. All rights reserved.
 *
 *  FILEMAKER CONFIDENTIAL
 *  This file includes unpublished proprietary source code of FileMaker,
 *  Inc. The copyright notice above does not evidence any actual or
 *  intended publication of such source code.
 */
'use strict';
var util = require('../routes/util');
var errorHandler = require('../routes/error');

module.exports.executeScript = function(req, res, next) {
	var missingParam = [];
	var ipStr = util.parseClientIp(req);
	var params = {
		'solution': req.swagger.params.database.value,
		'layout': req.swagger.params.layout.value,
		'requestMethod': req.method,
		'requestPath': req.originalUrl,
		'requestIp': ipStr,
		'requestHostname' : 'https://' + req.get("X-Forwarded-Host"), // get X-Forwarded-Host instead of req.hostname to get port number as well and prepend https
		'inputBandwidth': (req.body) ? JSON.stringify(req.body).length.toString() : "0",
		'version': req.swagger.params.version.value,
		'script' : req.swagger.params.scriptName.value
	};

	var result = util.setAuthentication(req, res, params, false);	
	if(result){
		for (var propName in req.query) {
			// enforce that only supported query parameters are allowed
			if( (['scriptName','script.param'].indexOf(propName) === -1) )
				return errorHandler.handleError('BadRequest', req, res, 'Unknown parameter(s): '+propName,"960");
			var val = req.query[propName];
			if (val instanceof Array) {
				return errorHandler.handleError('BadRequest', req, res, 'Request contains multiple '+ propName +' parameters',"960")
			} else {
				params[propName.toLowerCase()] = req.query[propName];
			}
		}

		try {
			util.thrift_client.executeScript(
				params,
				function(thrifError, thrifResult) {
					return util.handleThrifReturn(thrifError, thrifResult, req, res);
				});
		} catch (err){
			util.thriftExceptionHandler(err, req, res);
		}
	}
}
